<?php
// ######################### REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/class_bootstrap_framework.php');
require_once(DIR . '/includes/functions_bigthree.php');
require_once(DIR . '/includes/class_taggablecontent.php');
require_once(DIR . '/vb/types.php');
require_once(DIR . '/includes/searchwords.php');
require_once(DIR . '/includes/adminfunctions.php');

if ($vbulletin->options['amp_auto_tagger_enabled']){
	// Remove spaces from badword list
	$taggerbadwords = str_replace(" ","",$vbulletin->options["amptaggerbadwords"]); 

	// Merge VB Badwords with AMP Badwords 
	$taggerbadwords = array_filter(array_unique(array_merge(explode(",",$taggerbadwords),$badwords))); 

	// Build badwords regex
	$taggerbadwords = implode('\\b)|(\\b',$taggerbadwords);
	$taggerbadwords = "/(\\b$taggerbadwords\\b)/";

	// Get good words and other languages
	$ampgoodwords = $vbulletin->options["ampgoodwords"]; 
	$special_char = $vbulletin->options["amptaggerspecialchar"]; 

	// Get cron settings
	$ampautotaggercronpurgeall = $vbulletin->options["ampautotaggercronpurgeall"];
	$ampautotaggercronpurge = $vbulletin->options["ampautotaggercronpurge"];

	// Build numbers regex
	if ($vbulletin->options["ampno_numbers"]){ 
		$no_numbers = ''; 
	}else{ 
		$no_numbers = '0-9'; 
	} 

	// ### We run through three times to make sure everything gets hit. ###
	// ### If the purge on error setitng is set in VB Options threads that have errors will be purged and rebuilt on the third pass.

	// First pass as normal
	amp_autotagger_run(1);

	// Add missing keywords if nessary
	amp_add_missing_keywords();
	echo "<font color='green'><hr /><h1>Pass 1: Complete</h1><hr /></font>";

	// Now run second pass. Really there should be nothing here now.
	amp_autotagger_run(2);
	echo "<font color='green'><hr /><h1>Pass 2: Complete</h1><hr /></font>";

	// Now run final pass. If there's something coming back then purge and readd
	amp_autotagger_run(3);
	amp_add_missing_keywords();

	// Provided everything went smooth... done.
	echo "<font color='green'><hr /><h1>Pass 3: Complete</h1><hr /></font>";
	echo "<font color='green'><h1>Cron Job Complete!</h1></font><br />";
	log_cron_action('AMP Auto Tagger Cron Completed Successfully', $nextitem, 0);
}else{
	$amp_cron_enabledmsg = "AMP Auto Tagger is not enabled. Please enable in AdminCP>Options>AMP Auto Tagger";
	echo $amp_cron_enabledmsg;
	log_cron_action($amp_cron_enabledmsg, $nextitem, 0);	
}
function amp_autotagger_run($iteration){
	global $ampautotaggercronpurgeall,$vbulletin;

	// If purge all is set select all threads
	if ($ampautotaggercronpurgeall){
		$threads = $vbulletin->db->query_read("
			SELECT threadid
			FROM " . TABLE_PREFIX . "thread
			");
	}else{
	// Find all threads missing either Tags or Keywords
		$threads = $vbulletin->db->query_read("
			SELECT threadid
			FROM " . TABLE_PREFIX . "thread
			WHERE taglist = ''
			OR taglist IS NULL 
			OR taglist = 'NULL'
			OR taglist = ','
			OR keywords = ''
			OR keywords IS NULL
			OR keywords = 'NULL'
			OR keywords = ','
			");
	}
	// Update each thread accordingly 
	$tagged = 0;
	while ($thread = $vbulletin->db->fetch_array($threads)){
		// This will throttle the updates and keep the server from getting crushed. This is good for big ass forums.
		if ($tagged > 1000){
			$tagged = 0;
			if( !ini_get('safe_mode') ){ 
				set_time_limit(3600); 
			} 
			sleep(1);
		}
		$tagged++;
		$amptagger_results = amp_add_tags($thread['threadid'],2,$iteration);
		echo $amptagger_results;
		log_cron_action($amptagger_results, $nextitem, 0);
		vbflush();
	}
}

function amp_add_tags($contentid,$contenttypeid = 2,$iteration){
	global $ampautotaggercronpurgeall,$ampautotaggercronpurge;
	$content = vB_Taggable_Content_Item::create($vbulletin, $contenttypeid, $contentid);
	$amp_taglist = amp_filter_tags($content->get_title());
	if (($ampautotaggercronpurgeall) || ($iteration == 3 && $ampautotaggercronpurge)){
		echo "<font color='green'><hr /><b> (Rebuiling Tags) </b></font>";
		log_cron_action("Rebuilding tags for: $contentid", $nextitem, 0);
		$content->delete_tag_attachments();
		$content->rebuild_content_tags();
	}
	$limits = $content->fetch_tag_limits();
	$errors = $content->add_tags_to_content($amp_taglist, $limits);
	if ($errors){
		$tag_error = implode(',',$errors);
		return "<b><font color='red'>Failed to write: $amp_taglist <br />To threadid: $contentid - Error: $tag_error</font></b><br /><br />\n";;
	}else{
		return "Wrote: $amp_taglist <br />To threadid: $contentid <br /><br />\n";		
	}
}

function amp_filter_tags($title){
	global $taggerbadwords, $special_char, $no_numbers, $ampgoodwords;
	$ampgoodwords = strtolower($ampgoodwords);
	$special_char = trim($special_char);
	$title = strtolower($title);
	$title = preg_replace("!\\b\\w{1,2}\\b!", "",$title);
	$title = preg_replace("/[^A-Za-z_  $special_char$no_numbers]/",'',$title);
	$title = preg_replace($taggerbadwords,"",trim($title));
	// I think this is the fastest way to remove blanks, remove duplicate tags, merge goodwords, and then convert to cammas in the returned value
	$title = array_filter(array_unique(array_merge(explode(' ',$title),explode(',',$ampgoodwords))));
	return implode(',',$title);
}

// Code borrowed from misc.php
function amp_add_missing_keywords(){
	global $vbulletin;
	require_once(DIR . '/includes/functions_newpost.php');

	$threads = $vbulletin->db->query_read($query = "
		SELECT thread.threadid, thread.taglist, thread.prefixid, thread.title, post.pagetext AS firstpost
		FROM " . TABLE_PREFIX . "thread AS thread
		LEFT JOIN " . TABLE_PREFIX . "post AS post ON(post.postid = thread.firstpostid)
		WHERE thread.keywords IS NULL
		ORDER BY threadid ASC
	");
	while ($thread = $vbulletin->db->fetch_array($threads)){
		$threadinfo = fetch_threadinfo($thread['threadid']);
		$keywords = fetch_keywords_list($threadinfo, $thread['firstpost']);
		$threadman =& datamanager_init('Thread', $vbulletin, ERRTYPE_SILENT, 'threadpost');
		$threadman->set_existing($threadinfo);
		$threadman->set('keywords', $keywords);
		$threadman->save();
		unset($threadman);
		echo "Updated keywords for: ".$thread['threadid']."<br />\n";
		log_cron_action('Updated keywords for: '.$thread['threadid'], $nextitem, 0);
		vbflush();
	}
}
?>
